clear all
set matsize 10000
set maxvar 10000
set more off

cd "\IRI data"
	
*** Program to estimate fzpizza prices (including heterogeneity by brand)

	import delimited "fzpizza_panel.csv"
	drop f d pr year qtrid parent vendor product_type package
	
** Setup
	rename iri_key stores
	rename week weekid
	replace weekid = weekid - 1113
	egen upc = group(colupc)
	egen id = group(stores upc)
	drop colupc
	xtset id weekid
	
	rename stores iri_key
	merge m:1 iri_key using stores_market.dta
	keep if _merge==3
	drop _merge
	rename iri_key stores
	encode market, gen(mkt)
	drop market
	
** Restrict sample
	by upc, sort: egen min = min(weekid)
	by upc, sort: egen max = max(weekid)
	gen T = max-min
	drop if T < 26
	
	qui unique stores, by(upc) gen(N)
	drop if N < 5 & strpos(product,"PRIVATE LABEL")==0
	
	drop min max T N
	
** Create WM post-entry and entry week indicator
	rename stores iri_key
	merge m:1 iri_key using entries_wide_11.dta
	drop if _merge==2
	drop _merge
	rename iri_key stores

	rename wmid* idwm*
	drop idwm*
	forvalues i=1/19 {
		capture gen wm`i' = (weekid >= week`i')
		capture gen enter`i' = (weekid == week`i')
		capture replace dis`i' = 0 if wm`i' == 0
		capture drop week`i'
		}
	egen wm = rowtotal(wm*)
	egen enter = rowtotal(enter*)
	drop wm1-enter12
	
	* Distance spline
	forvalues s=1/1 {
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > 0 )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}

	forvalues s=3(2)11 {
		local s0 = `s'-2
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > `s0' )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}
	drop dis*
	compress
	
** Merge in store names
	rename stores iri_key
	merge m:1 iri_key using store_names.dta
	drop if _merge == 2
	drop _merge
	rename iri_key stores
	
	* Merge in chain info
	merge m:1 name using chain.dta
	drop _merge
	
	gen missing_chain = (chainid ==.)
	
	replace firmtype = 3 if firmtype == 4
	encode name, gen(chain)
	replace chain = 0 if missing_chain == 1
	
	drop name
	compress
	
** Treatment groups
	by stores, sort: egen treat_nwm = max(wm)
*	by stores, sort: egen wm0 = min(wm)
	
*	gen wm_diff = treat_nwm - wm0
	
** Brands
	gen amys = (strpos(product,"AMYS")>0)
	gen capzkitchen = (strpos(product,"CALIFORNIA PIZZA KITCHEN")>0)
	gen celeste = (strpos(product,"CELESTE")>0)
	gen digiorno = (strpos(product,"DI GIORNO")>0)
	gen freschetta = (strpos(product,"FRESCHETTA")>0)
	gen jacks = (strpos(product,"JACKS")>0)
	gen private = (strpos(product,"PRIVATE LABEL")>0)
	gen redbaron = (strpos(product,"RED BARON")>0)
	gen stouffers = (strpos(product,"STOUFFERS")>0)
	gen tombstone = (strpos(product,"TOMBSTONE")>0)
	gen tonys = (strpos(product,"TONYS")>0)
	gen totinos = (strpos(product,"TOTINOS")>0)
	
	egen other = rowtotal(amys-totinos)
	replace other = 1-other
	
	drop product
	compress
	
** Create variables
	merge m:1 monthid using cpi.dta
	drop _merge
	
	gen ppvol = (dollars / (units * vol_eq))  / cpi * 100
	gen logp = log(ppvol)
	
	drop dollars units vol_eq cpi monthid year month
	compress
	
	gen wm_lt7 = wm_1+wm_3+wm_5+wm_7
	gen wm_lt5 = wm_1+wm_3+wm_5
	
*** Summaries
	foreach var of varlist amys-other {
		summarize ppvol if `var' == 1, detail
}
	
*** Brand prices
	cd "\Results"
	
	foreach var of varlist wm_lt7 {
		reghdfe logp enter `var', a(i.mkt#i.upc#i.week id) cluster(stores) keepsing
			outreg2 using final_fzpizza, excel
		reghdfe logp enter c.`var'#c.(amy-other), a(i.mkt#i.upc#i.week id) cluster(stores) keepsing
			outreg2 using final_fzpizza, excel
		}
	
*** Brand revenues

	gen brand=.
	local j=0
	foreach var of varlist amys-other {
		replace brand = `j'+1 if `var'==1
		local j=`j'+1
		}
	
	gen revenue = dollars / cpi * 100
	
	collapse (sum) revenue, by(stores brand weekid wm enter mkt wm_1-wm_11 treat_nwm)
	
	egen storesbrand = group(stores brand)
	drop if storesbrand==.
	xtset storesbrand weekid
	
	gen logrev = log(revenue)
	
	gen wm_lt7 = wm_1+wm_3+wm_5+wm_7
	gen wm_lt5 = wm_1+wm_3+wm_5
	
	compress
	
	
	foreach var of varlist wm_lt5 {
		xtreg logrev enter `var' i.weekid c.weekid#i.brand c.weekid#c.weekid#i.brand c.weekid#i.mkt c.weekid#c.weekid#i.mkt c.weekid#i.treat_nwm c.weekid#c.weekid#i.treat_nwm, fe i(storesbrand) cluster(stores)
			outreg2 using final_fzpizza_rev, excel
		xtreg logrev enter c.`var'#i.brand i.weekid c.weekid#i.brand c.weekid#c.weekid#i.brand c.weekid#i.mkt c.weekid#c.weekid#i.mkt c.weekid#i.treat_nwm c.weekid#c.weekid#i.treat_nwm, fe i(storesbrand) cluster(stores)
			outreg2 using final_fzpizza_rev, excel
		}
	
	
	
	
	
	